<?xml version="1.0" encoding="UTF-8"?>
<!-- 
####################################################################################
#  XSL name : section0
#  Version : R2.0.9.S01                                        
#  Intermediate release number : 014-20161025                                      
#  Last update : 02/09/2016                                                            
####################################################################################
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" xmlns:mi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ted="http://formex.publications.europa.eu/ted/schema/reception/R2.0.9.S01" exclude-result-prefixes="ted">
	<!---->
	<xsl:template match="@mi:schemaLocation" mode="R998">
		<xsl:if test="not(matches(normalize-space(string()),'^([^\s]+&#x20;[^\s]+\.xsd(&#x20;[^\s]+&#x20;[^\s]+\.xsd)*)$'))">
			<xsl:variable name="attr" select="concat('xsi:schemaLocation with value ', &quot;'&quot;, string(), &quot;'&quot;)"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R998'"/>
				<xsl:with-param name="content" select="$attr"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="*" mode="R100">
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R100'"/>
			<xsl:with-param name="content" select="''"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:FORM_SECTION" mode="R101">
		<xsl:if test=".//*[@CURRENCY != .//*/@CURRENCY[1]]">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R101'"/>
				<xsl:with-param name="content" select="''"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="ted:E_MAIL" mode="R102">
		<xsl:variable name="ele">'<xsl:value-of select="normalize-space(text())"/>'</xsl:variable>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R102'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]" mode="R104">
		<xsl:if test=".//ted:OBJECT_CONTRACT[position()!=@ITEM] ">
			<xsl:variable name="ele" select="'OBJECT_CONTRACT/@ITEM'"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R104'"/>
				<xsl:with-param name="content" select="$ele"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test=".//ted:OBJECT_CONTRACT[child::ted:OBJECT_DESCR[position()!=@ITEM]] ">
			<xsl:variable name="ele" select="'OBJECT_DESCR/@ITEM'"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R104'"/>
				<xsl:with-param name="content" select="$ele"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test=".//ted:AWARD_CONTRACT[position()!=@ITEM]">
			<xsl:variable name="ele" select="'AWARD_CONTRACT/@ITEM'"/>
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R104'"/>
				<xsl:with-param name="content" select="$ele"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="ted:USER_E_MAIL|ted:E_MAIL" mode="R105">
		<xsl:if test="(string-length(normalize-space(.))&gt; 200  ) or (string-length(normalize-space(.))&gt; 0 and not(matches(normalize-space(.),'^[A-Za-z0-9!#$%&amp;''*+/=?_-]+(\.[A-Za-z0-9!#$%&amp;''*+/=?_-]+)*@([A-Za-z0-9]([A-Za-z0-9-]*[A-Za-z0-9])?\.)+([A-Za-z]{2,})$')))">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R105'"/>
				<xsl:with-param name="content" select="concat(local-name(.),' with value ', &quot;'&quot;, normalize-space(./text()), &quot;'&quot;)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="*[ted:DATE_END/number(replace(text(),'-','')) &lt;= ted:DATE_START/number(replace(text(),'-',''))]" mode="R106">
		<xsl:variable name="ele" select="concat(local-name(parent::*),'[',parent::*/@ITEM,']/',local-name(),'[',@ITEM,'][DATE_START=',ted:DATE_START/text(),', ','DATE_END=',ted:DATE_END/text(),']')"/>
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R106'"/>
			<xsl:with-param name="content" select="$ele"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="ted:NOTICE_NUMBER_OJ" mode="R107">
		<xsl:choose>
			<xsl:when test="matches(./text(),'^(20|19)\d{2}/S (((00)?[1-9])|([0]?[1-9][0-9])|(1[0-9][0-9])|(2[0-5][0-9]))-\d{6}$')"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R107'"/>
					<xsl:with-param name="content" select="concat(local-name(.),' with value ',current())"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]" mode="R115">
		<xsl:call-template name="msg">
			<xsl:with-param name="rule" select="'R115'"/>
			<xsl:with-param name="content" select="concat('Total CPV: ',count(.//*[matches(local-name(),'CPV')][attribute::CODE]/@CODE),' / Unique CPV: ',count(distinct-values(.//*[matches(local-name(),'CPV')][attribute::CODE]/@CODE)))"/>
		</xsl:call-template>
	</xsl:template>
	<!---->
	<xsl:template match="*[@FORM]" mode="R116">
		<xsl:if test=".//ted:LOT_DIVISION">
			<xsl:call-template name="msg">
				<xsl:with-param name="rule" select="'R116'"/>
				<xsl:with-param name="content" select="concat('Number of LOT: ',count(.//ted:OBJECT_DESCR))"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!---->
	<xsl:template match="ted:VAL_RANGE_OBJECT|ted:VAL_RANGE_TOTAL" mode="R158">
		<xsl:choose>
			<xsl:when test="number(ted:LOW/text())>0 and number(ted:HIGH/text())&gt;=number(ted:LOW/text())"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R158'"/>
					<xsl:with-param name="content" select="concat(local-name(),'[@HIGH=',string(./ted:HIGH),', @LOW=',string(./ted:LOW),']')"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!---->
	<xsl:template match="ted:DATE_DISPATCH_NOTICE" mode="R251">
		<xsl:choose>
			<xsl:when test="number(substring-before(//ted:IDENTIFICATION/ted:NO_DOC_EXT/text(),'-'))=number(substring-before(./text(),'-'))"/>
			<xsl:otherwise>
				<xsl:call-template name="msg">
					<xsl:with-param name="rule" select="'R251'"/>
					<xsl:with-param name="content" select="concat('NO_DOC_EXT=',&quot;'&quot;,//ted:IDENTIFICATION/ted:NO_DOC_EXT/text(),&quot;'&quot;,', DATE_DISPATCH_NOTICE=',&quot;'&quot;,text(),&quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates mode="R251"/>
	</xsl:template>
</xsl:stylesheet>
